/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.wall;

import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;

public class Edge {
    public static final float EPSILON = 1.0E-4f;
    private final Vector2 pointA;
    private final Vector2 pointB;

    public Edge(Vector2 pointA, Vector2 pointB) {
        this.pointA = pointA;
        this.pointB = pointB;
    }

    public Vector2 getPointA() {
        return this.pointA;
    }

    public Vector2 getPointB() {
        return this.pointB;
    }

    public CompassDirection getDirection() {
        if (this.pointA.x == this.pointB.x) {
            if (this.pointA.y < this.pointB.y) {
                return CompassDirection.NORTH;
            }
            return CompassDirection.SOUTH;
        }
        if (this.pointA.x < this.pointB.x) {
            return CompassDirection.EAST;
        }
        return CompassDirection.WEST;
    }

    public float averageEndpointDistanceSquared() {
        float pointADistanceSquared = this.pointA.x * this.pointA.x + this.pointA.y * this.pointA.y;
        float pointBDistanceSquared = this.pointB.x * this.pointB.x + this.pointB.y * this.pointB.y;
        return (pointADistanceSquared + pointBDistanceSquared) / 2.0f;
    }

    public String toString() {
        return this.pointA.toString() + " -> " + this.pointB.toString();
    }

    public Edge reorderPointsClockwiseAroundOrigin() {
        if (Math.abs(this.pointA.x - this.pointB.x) < 1.0E-4f) {
            if (this.pointA.x > 0.0f) {
                if (this.pointA.y > this.pointB.y) {
                    return this;
                }
                return new Edge(this.pointB, this.pointA);
            }
            if (this.pointA.y < this.pointB.y) {
                return this;
            }
            return new Edge(this.pointB, this.pointA);
        }
        if (this.pointA.y > 0.0f) {
            if (this.pointA.x < this.pointB.x) {
                return this;
            }
            return new Edge(this.pointB, this.pointA);
        }
        if (this.pointA.x > this.pointB.x) {
            return this;
        }
        return new Edge(this.pointB, this.pointA);
    }
}

